<?php
header('Access-Control-Allow-Origin: *');
session_start();

// Inclui o arquivo de conexão com o banco de dados
require_once 'BancodeDados.php';

// Verifica se a conexão foi estabelecida corretamente
if (!isset($pdo)) {
    die(json_encode(['status' => 'error', 'message' => 'Erro: Conexão com o banco de dados não estabelecida.']));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se todos os campos necessários estão presentes
    $requiredFields = [
        'nome', 'anoModelo', 'cpfCnpj', 'renavam', 'placa', 'chassi', 'especieTipo', 
        'marcaModelo', 'capacidadeDePassageiros', 'capPotCil', 'combustivel', 
        'mesCRLV', 'corPredominante', 'anoFabricacao', 'Observacao'
    ];

    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            echo '1'; // Erro
        }
    }

    // Captura dos dados do formulário enviados via POST
    $nome = $_POST['nome'];
    $anoModelo = $_POST['anoModelo'];
    $cpfCnpj = $_POST['cpfCnpj'];
    $renavam = $_POST['renavam'];
    $placa = $_POST['placa'];
    $chassi = $_POST['chassi'];
    $especieTipo = $_POST['especieTipo'];
    $marcaModelo = $_POST['marcaModelo'];
    $capacidadeDePassageiros = $_POST['capacidadeDePassageiros'];
    $capPotCil = $_POST['capPotCil'];
    $combustivel = $_POST['combustivel'];
    $mesCRLV = $_POST['mesCRLV'];
    $corPredominante = $_POST['corPredominante'];
    $anoFabricacao = $_POST['anoFabricacao'];
    $observacao = $_POST['Observacao'];

    
        // Preparação da query SQL
        $sql = "INSERT INTO cad_carro (
                    nome, ano_modelo, cpf_cnpj, renavam, placa, chassi, especie_tipo, marca_modelo, 
                    capacidade_de_passageiros, cap_pot_cil, combustivel, mes_crlv, cor_predominante, 
                    ano_fabricacao, observacao, data_criacao, data_atualizacao
                ) VALUES (
                    :nome, :anoModelo, :cpfCnpj, :renavam, :placa, :chassi, :especieTipo, :marcaModelo, 
                    :capacidadeDePassageiros, :capPotCil, :combustivel, :mesCRLV, :corPredominante, 
                    :anoFabricacao, :observacao, NOW(), NOW()
                )";
        $stmt = $pdo->prepare($sql);

        // Vinculação dos parâmetros usando bindValue
        $stmt->bindValue(':nome', $nome);
        $stmt->bindValue(':anoModelo', $anoModelo);
        $stmt->bindValue(':cpfCnpj', $cpfCnpj);
        $stmt->bindValue(':renavam', $renavam);
        $stmt->bindValue(':placa', $placa);
        $stmt->bindValue(':chassi', $chassi);
        $stmt->bindValue(':especieTipo', $especieTipo);
        $stmt->bindValue(':marcaModelo', $marcaModelo);
        $stmt->bindValue(':capacidadeDePassageiros', $capacidadeDePassageiros);
        $stmt->bindValue(':capPotCil', $capPotCil);
        $stmt->bindValue(':combustivel', $combustivel);
        $stmt->bindValue(':mesCRLV', $mesCRLV);
        $stmt->bindValue(':corPredominante', $corPredominante);
        $stmt->bindValue(':anoFabricacao', $anoFabricacao);
        $stmt->bindValue(':observacao', $observacao);

        // Executa a query
        if ($stmt->execute()) {
        echo '3'; // Sucesso
    } else {
        echo '2'; // Erro
    }
} else {
    echo '4'; // Método não permitido
}
?>